﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet.Model
{

    /// <summary>
    /// The Patient object is a read-only object used for patient context.
    /// </summary>
    public interface Patient
    {
        /// <summary>
        /// The RPMS intenal entry number for the patient
        /// </summary>
        String Ien { get; }

        /// <summary>
        /// The RPMS HRN or chart number
        /// </summary>
        String HealthRecordNumber { get; }

        /// <summary>
        /// The default displayable version of the patient's name
        /// </summary>
        String PatientName { get; }

        /// <summary>
        /// The current admission date of the user.  This is a nullable bool for the cases that
        /// the patient is not currently admitted.
        /// </summary>
        DateTime? AdmitDate { get; }
        /// <summary>
        /// The current age of the patient.
        /// </summary>
        float Age { get; }
        /// <summary>
        /// If knownn, the DOB of the patient
        /// </summary>
        DateTime? Dob { get; }
        /// <summary>
        /// The displayable name (external value) of the patient's primary provider.
        /// </summary>
        String PrimaryProvider { get; }
        /// <summary>
        /// The sex of the patient
        /// </summary>
        String Sex { get; }
        /// <summary>
        /// The patient's SSN or an abbrievation of the SSN
        /// </summary>
        String Ssn { get; }
    }
}
